<?php

   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    class Utente {
        private $db;
        private $id; 
        private $email;
        private $password; 
        private $ruolo;
        private $attivo; 
        private $nome;
        private $cognome;
        private $sesso;
        private $foto;
        private $descrizione;
        private $note;
        private $via;
        private $citta;
        private $cap;
        private $dataNascita;
        private $luogoNascita;
        private $provinciaNascita;
        private $telefono;
        private $codiceFiscale;
        private $partitaIva;
        private $organizzazione;
        private $sitoWeb;
        private $pec;
        private $codiceInterscambio;
        private $stato;
        private $ricezioneMail;
        private $etichetta;
        private $dataCreazione;
        private $ultimoLogin;
        
        function __construct($db, $id, $email="", $password="", $ruolo="", $attivo="", $nome="", $cognome="", $sesso = "", $foto="", $descrizione="", $note = "", $via="", $citta="", $cap="", $dataNascita = null, $luogoNascita = "", $provinciaNascita = "", $telefono="", $codiceFiscale="", $partitaIva="", $organizzazione="", $sitoWeb="", $pec="", $codiceInterscambio="", $stato="", $ricezioneMail = "", $etichetta="") {
            $this->db = $db;
            $this->id = $id;
            $this->email       = $email;
            $this->password    = $password;
            $this->ruolo       = $ruolo;
            $this->attivo      = $attivo;
            $this->nome        = $nome;
            $this->cognome     = $cognome;
            $this->sesso       = $sesso;
            $this->foto        = $foto;
            $this->descrizione = $descrizione;
            $this->note        = $note;
            $this->via         = $via;
            $this->citta       = $citta;
            $this->cap         = $cap;
            $this->dataNascita      = $dataNascita; 
            $this->luogoNascita     = $luogoNascita;
            $this->provinciaNascita = $provinciaNascita;
            $this->telefono         = $telefono;
            $this->codiceFiscale    = $codiceFiscale;
            $this->partitaIva       = $partitaIva;
            $this->organizzazione   = $organizzazione;
            $this->sitoWeb          = $sitoWeb;
            $this->pec              = $pec;
            $this->codiceInterscambio = $codiceInterscambio;
            $this->stato         = $stato;
            $this->ricezioneMail = $ricezioneMail;
            $this->etichetta     = $etichetta;
        }

        function crea() {
            $dataOggi = date("Y-m-d");
            $dataNascita = ($this->dataNascita=="") ? "NULL" : "'$this->dataNascita'";
            
            $query = "INSERT INTO `geec_utenti` (`id`, `email`, `password`, `ruolo`, `nome`, `cognome`, `sesso`, `foto`, `descrizione`, `note`, `via`, `citta`, `cap`, `dataNascita`, `luogoNascita`, `provinciaNascita`, `telefono`, `codiceFiscale`, `partitaIva`, `organizzazione`, `sitoWeb`, `pec`, `codiceInterscambio`, `stato`, `ricezioneMail`,`etichetta`, `dataCreazione`, `ultimoLogin`) VALUES
(NULL, '$this->email', '$this->password', '$this->ruolo', '$this->nome', '$this->cognome', '$this->sesso', '$this->foto', '$this->descrizione', '$this->note', '$this->via', '$this->citta', '$this->cap', $dataNascita, '$this->luogoNascita', '$this->provinciaNascita', '$this->telefono', '$this->codiceFiscale', '$this->partitaIva', '$this->organizzazione','$this->sitoWeb', '$this->pec', '$this->codiceInterscambio', '$this->stato', '$this->ricezioneMail', '$this->etichetta', '$dataOggi', '$dataOggi')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        /*
         * Duplica un utente, che viene impostato con email e password vuote e stato non attivo
         */
        function duplica() {
            $dataOggi = date("Y-m-d");
            $contenutoDaCopiare = $this->db->leggiSingolaRiga("geec_utenti",$this->id);
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_utenti WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_utenti SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $query = "UPDATE `geec_utenti` SET email='', password='', stato='non attivo', dataCreazione = '$dataOggi', ultimoLogin = '$dataOggi' WHERE id = $this->id";
            $this->db->eseguiQueryCreazione($query);
            return $idContenutoDuplicato;
        }
        
        function modifica() {
            $dataNascita = ($this->dataNascita=="") ? "NULL" : "'$this->dataNascita'";
            
            $query = "UPDATE `geec_utenti` SET ruolo = '$this->ruolo', email = '$this->email', password = '$this->password', nome = '$this->nome', cognome = '$this->cognome', sesso = '$this->sesso', foto = '$this->foto', descrizione = '$this->descrizione', note = '$this->note', via = '$this->via', citta = '$this->citta', cap = '$this->cap', dataNascita=$dataNascita, luogoNascita='$this->luogoNascita', provinciaNascita='$this->provinciaNascita', telefono = '$this->telefono', codiceFiscale = '$this->codiceFiscale', partitaIva = '$this->partitaIva', organizzazione = '$this->organizzazione', sitoWeb = '$this->sitoWeb', pec = '$this->pec', codiceInterscambio = '$this->codiceInterscambio', stato = '$this->stato', ricezioneMail='$this->ricezioneMail', etichetta = '$this->etichetta' WHERE id = $this->id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function aggiornaFoto($percorsoFoto) {
            $query = "UPDATE `geec_utenti` SET foto = '$percorsoFoto' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);            
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_utenti",$this->id);
            
            // elimino i gruppi associati a questo utente
            $query = "DELETE FROM geec_gruppiUtenti WHERE idUtente = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function caricaDatiDalDatabase() {
            $datiUtente  = $this->db->leggiSingolaRiga("geec_utenti",$this->id);
            if($datiUtente) { // se esiste l'utente
                $this->email    = $datiUtente["email"];
                $this->password = $datiUtente["password"];
                $this->ruolo    = $datiUtente["ruolo"];
                $this->nome     = $datiUtente["nome"];
                $this->cognome  = $datiUtente["cognome"];
                $this->sesso    = $datiUtente["sesso"];
                $this->foto     = $datiUtente["foto"];
                $this->descrizione = $datiUtente["descrizione"];
                $this->note        = $datiUtente["note"];
                $this->via      = $datiUtente["via"];
                $this->citta    = $datiUtente["citta"];
                $this->cap      = $datiUtente["cap"];
                $this->dataNascita    = $datiUtente["dataNascita"];
                $this->luogoNascita   = $datiUtente["luogoNascita"];
                $this->provinciaNascita = $datiUtente["provinciaNascita"];
                $this->telefono = $datiUtente["telefono"];
                $this->codiceFiscale  = $datiUtente["codiceFiscale"];
                $this->partitaIva     = $datiUtente["partitaIva"];
                $this->organizzazione = $datiUtente["organizzazione"];
                $this->sitoWeb        = $datiUtente["sitoWeb"];
                $this->pec            = $datiUtente["pec"];
                $this->codiceInterscambio = $datiUtente["codiceInterscambio"];
                $this->stato              = $datiUtente["stato"];
                $this->ricezioneMail      = $datiUtente["ricezioneMail"];
                $this->etichetta          = $datiUtente["etichetta"];
            }
        }
        
        function aggiungiAGruppo($idGruppo) {
            $query = "SELECT * FROM `geec_gruppiUtenti` WHERE idUtente=$this->id AND idGruppo='$idGruppo' ";
            $risGruppiUtenti = $this->db->eseguiQueryLettura($query);
            if($risGruppiUtenti->num_rows>0) {
                return "L'utente è già associato a questo gruppo";
            }
            else {
                $query = "INSERT INTO `geec_gruppiUtenti` (`idGruppoUtente`, `idUtente`, `idGruppo`) VALUES (NULL, '$this->id', '$idGruppo')";
                $this->db->eseguiQueryCreazione($query);
                return "ok";
            }
        }
        
        function cambiaPassword($password) {
            $nuovaPassword = hash("sha512",$password);
            $query    = "UPDATE `geec_utenti` SET password='$nuovaPassword' WHERE id='$this->id'";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function aggiornaStato($stato) {
            $query = "UPDATE `geec_utenti` SET stato = '$stato' WHERE id='$this->id'";
            $this->db->eseguiQueryCreazione($query);
        }
        
        // getter & setter
        function getDb() {
            return $this->db;
        }
        
        function getId() {
            return $this->id;
        }

        function getEmail() {
            return $this->email;
        }

        function getPassword() {
            return $this->password;
        }

        function getRuolo() {
            return $this->ruolo;
        }

        function getAttivo() {
            return $this->attivo;
        }

        function getNome() {
            return $this->nome;
        }

        function getCognome() {
            return $this->cognome;
        }

        function getSesso() {
            return $this->sesso;
        }

        function getFoto() {
            return $this->foto;
        }

        function getDescrizione() {
            return $this->descrizione;
        }

        function getNote() {
            return $this->note;
        }
        
        function getVia() {
            return $this->via;
        }

        function getCitta() {
            return $this->citta;
        }

        function getCap() {
            return $this->cap;
        }

        function getDataNascita() {
            return $this->dataNascita;
        }

        function getLuogoNascita() {
            return $this->luogoNascita;
        }

        function getProvinciaNascita() {
            return $this->provinciaNascita;
        }

        function getTelefono() {
            return $this->telefono;
        }

        function getCodiceFiscale() {
            return $this->codiceFiscale;
        }

        function getPartitaIva() {
            return $this->partitaIva;
        }

        function getOrganizzazione() {
            return $this->organizzazione;
        }

        function getSitoWeb() {
            return $this->sitoWeb;
        }

        function getPec() {
            return $this->pec;
        }

        function getCodiceInterscambio() {
            return $this->codiceInterscambio;
        }

        function getStato() {
            return $this->stato;
        }

        public function getRicezioneMail() {
            return $this->ricezioneMail;
        }

        function getEtichetta() {
            return $this->etichetta;
        }

        function getDataCreazione() {
            return $this->dataCreazione;
        }

        function getUltimoLogin() {
            return $this->ultimoLogin;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setEmail($email) {
            $this->email = $email;
        }

        function setPassword($password) {
            $this->password = $password;
        }

        function setRuolo($ruolo) {
            $this->ruolo = $ruolo;
        }

        function setAttivo($attivo) {
            $this->attivo = $attivo;
        }

        function setNome($nome) {
            $this->nome = $nome;
        }

        function setCognome($cognome) {
            $this->cognome = $cognome;
        }

        function setSesso($sesso): void {
            $this->sesso = $sesso;
        }

        function setFoto($foto) {
            $this->foto = $foto;
        }

        function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }

        function setNote($note) {
            $this->note = $note;
        }
        
        function setVia($via) {
            $this->via = $via;
        }

        function setCitta($citta) {
            $this->citta = $citta;
        }

        function setCap($cap) {
            $this->cap = $cap;
        }

        function setDataNascita($dataNascita): void {
            $this->dataNascita = $dataNascita;
        }

        function setLuogoNascita($luogoNascita): void {
            $this->luogoNascita = $luogoNascita;
        }

        function setProvinciaNascita($provinciaNascita): void {
            $this->provinciaNascita = $provinciaNascita;
        }

        function setTelefono($telefono) {
            $this->telefono = $telefono;
        }

        function setCodiceFiscale($codiceFiscale) {
            $this->codiceFiscale = $codiceFiscale;
        }

        function setPartitaIva($partitaIva) {
            $this->partitaIva = $partitaIva;
        }

        function setOrganizzazione($organizzazione) {
            $this->organizzazione = $organizzazione;
        }

        function setSitoWeb($sitoWeb) {
            $this->sitoWeb = $sitoWeb;
        }

        function setPec($pec) {
            $this->pec = $pec;
        }

        function setCodiceInterscambio($codiceInterscambio) {
            $this->codiceInterscambio = $codiceInterscambio;
        }

        function setStato($stato) {
            $this->stato = $stato;
        }

        public function setRicezioneMail($ricezioneMail): void {
            $this->ricezioneMail = $ricezioneMail;
        }
        
        function setEtichetta($etichetta) {
            $this->etichetta = $etichetta;
        }

        function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }

        function setUltimoLogin($ultimoLogin) {
            $this->ultimoLogin = $ultimoLogin;
        }
    }
